/**
  ******************************************************************************
  * @file    py32md530_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP.
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
  * @brief Initialize ADC MSP.
  */
void HAL_ADC_MspInit(ADC_HandleTypeDef *hadc)
{
  RCC_PeriphCLKInitTypeDef RCC_PeriphCLKInit = {0};
  GPIO_InitTypeDef         GPIO_InitStruct   = {0};
  
  /* ADC clock source select system clock  */
  RCC_PeriphCLKInit.PeriphClockSelection= RCC_PERIPHCLK_ADC;
  RCC_PeriphCLKInit.AdcClockSelection   = RCC_ADCCLKSOURCE_SYSCLK;
  HAL_RCCEx_PeriphCLKConfig(&RCC_PeriphCLKInit);
  
  /* Enable ADC and GPIO clock */
  __HAL_RCC_ADC_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  
  GPIO_InitStruct.Pin = GPIO_PIN_4 | GPIO_PIN_5 | GPIO_PIN_6 | GPIO_PIN_7;
  GPIO_InitStruct.Mode = GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  __HAL_RCC_DMA1_CLK_ENABLE();                               /*Enable DMA clock*/
  
  hDMA.Instance = DMA1_Channel1;
  hDMA.Init.Direction           = DMA_PERIPH_TO_MEMORY;
  hDMA.Init.PeriphInc           = DMA_PADDR_FIX;
  hDMA.Init.MemInc              = DMA_MADDR_INC;
  hDMA.Init.PeriphDataAlignment = DMA_PDATAALIGN_WORD;
  hDMA.Init.MemDataAlignment    = DMA_MDATAALIGN_WORD;
  hDMA.Init.Mode                = DMA_NORMAL;
  hDMA.Init.Priority            = DMA_PRIORITY_0;
  hDMA.Init.TransMode           = DMA_TRANSFER_SINGLE;
  /* DMA initialization */
  if (HAL_DMA_Init(&hDMA) != HAL_OK)                   
  {
    APP_ErrorHandler();
  }
 
  HAL_DMA_ChannelMap(&hDMA, DMA_CHANNEL_MAP_ADC);
  
  __HAL_LINKDMA(hadc, DMA_Handle, hDMA);
  
  /* DMA channel 1 interrupt enable */
  HAL_NVIC_SetPriority(DMA1_Channel1_IRQn,3,0);
  HAL_NVIC_EnableIRQ(DMA1_Channel1_IRQn);
}

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
